from PyQt6.QtWidgets import (
    QDialog, QVBoxLayout, QProgressBar, 
    QLabel, QPushButton
)
from PyQt6.QtCore import Qt, QTimer
import time

class TTSProgressDialog(QDialog):
    def __init__(self, parent=None, total_chunks=1):
        super().__init__(parent)
        self.setWindowTitle("Конвертация")
        self.setFixedSize(400, 150)
        
        self.progress = QProgressBar()
        self.progress.setRange(0, 100)
        self.progress.setValue(0)
        
        self.status_label = QLabel("Подготовка...")
        self.status_label.setAlignment(Qt.AlignmentFlag.AlignCenter)
        
        self.cancel_btn = QPushButton("Отмена")
        self.cancel_btn.clicked.connect(self.cancel)
        
        layout = QVBoxLayout()
        layout.addWidget(self.status_label)
        layout.addWidget(self.progress)
        layout.addWidget(self.cancel_btn)
        self.setLayout(layout)
        
        self.timer = QTimer()
        self.timer.timeout.connect(self.update_progress)
        self.is_cancelled = False
        self.total_chunks = total_chunks
        self.current_chunk = 0

    def start(self):
        self.show()

    def update_progress(self, current, total):
        # Плавное заполнение с задержкой 0.3 сек
        target_value = int((current / total) * 100)
        if abs(self.progress.value() - target_value) > 1:  # Если разница значительная
            self.progress.setValue(target_value)
        self.status_label.setText(f"Конвертация: {current//1000}K/{total//1000}K символов")

    def cancel(self):
        self.is_cancelled = True
        self.cancel_btn.setEnabled(False)
        self.status_label.setText("Отмена...")
        
        parent = self.parent()
        
        if parent is not None:
            # Получаем worker с проверкой
            worker = getattr(parent, 'worker', None)
            if worker is not None:
                worker.is_cancelled = True
                worker.terminate()
                if not worker.wait(1000):
                    worker.terminate()
                parent.worker = None  # type: ignore
            
            # Получаем progress_dialog с проверкой
            progress_dialog = getattr(parent, 'progress_dialog', None)
            if progress_dialog is not None:
                progress_dialog.close()  # type: ignore
        
        QTimer.singleShot(1000, self.reject)