from PyQt6.QtWidgets import (
    QDialog, QVBoxLayout, QProgressBar, 
    QLabel, QPushButton
)
from PyQt6.QtCore import Qt, QTimer

class TTSProgressDialog(QDialog):
    def __init__(self, parent=None):
        super().__init__(parent)
        self.setWindowTitle("Конвертация")
        self.setFixedSize(400, 150)
        
        self.progress = QProgressBar()
        self.progress.setRange(0, 100)
        self.progress.setValue(0)
        
        self.status_label = QLabel("Подготовка...")
        self.status_label.setAlignment(Qt.AlignmentFlag.AlignCenter)
        
        self.cancel_btn = QPushButton("Отмена")
        self.cancel_btn.clicked.connect(self.cancel)
        
        layout = QVBoxLayout()
        layout.addWidget(self.status_label)
        layout.addWidget(self.progress)
        layout.addWidget(self.cancel_btn)
        self.setLayout(layout)
        
        self.is_cancelled = False
        self.worker = None

    def set_worker(self, worker):
        """Связывает диалог с рабочим потоком"""
        self.worker = worker

    def start(self):
        """Показывает диалог"""
        self.show()
        self.raise_()
        self.activateWindow()

    def update_progress(self, current, total):
        """Обновляет прогресс-бар"""
        if total > 0:
            progress_value = int((current / total) * 100)
            self.progress.setValue(progress_value)

    def cancel(self):
        """Обработчик отмены"""
        self.is_cancelled = True
        self.cancel_btn.setEnabled(False)
        self.status_label.setText("Отмена...")
        
        if self.worker:
            self.worker.is_cancelled = True
        
        QTimer.singleShot(1000, self.close)

    def closeEvent(self, event):
        """Обработка закрытия окна"""
        if self.worker and hasattr(self.worker, 'isRunning') and self.worker.isRunning():
            self.worker.is_cancelled = True
        event.accept()